﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class EffectSelectionPane : UserControl
    {
        private EffectAuxBusControl _selectedControl;

        public EffectSelectionPane()
        {
            InitializeComponent();
        }

        #region ** プロパティ

        [Browsable(false)]
        [ReadOnly(true)]
        public Preview.EffectID SelectedEffectID
        {
            get
            {
                return new Preview.EffectID(SelectedControl.BusType, SelectedControl.SelectedEffectIndex);
            }
            set
            {
                if (value == SelectedEffectID) { return; }

                // 選択状態を更新する
                if (value.BusType != SelectedControl.BusType)
                {
                    SelectedControl.Reset();
                }

                GetTargetControl(value.BusType).SelectedEffectIndex = value.EffectIndex;
            }
        }

        [Browsable(false)]
        public Preview.EffectParameterSet SelectedParameters
        {
            get { return SelectedControl.SelectedParameters; }
        }

        [Browsable(false)]
        private EffectAuxBusControl SelectedControl
        {
            get { return _selectedControl; }
            set
            {
                if (value == _selectedControl) { return; }

                if (null != _selectedControl)
                {
                    _selectedControl.Reset();
                }
                _selectedControl = value;
            }
        }

        #endregion

        #region ** イベント

        public event EventHandler EffectSelectChanged;

        #endregion

        #region ** イベントハンドラ

        private void OnEffectSelectChanged(object sender, EventArgs e)
        {
            SelectedControl = sender as EffectAuxBusControl;
            DispatchSelectChangedEvent();
        }

        #endregion

        #region ** メソッド

        public void Initialize(Preview.EffectParameterCollection parameterSets)
        {
            Debug.Assert(null != parameterSets);

            // AuxBusコントロールを初期化する
            _auxA.Initialize(parameterSets);
            _auxB.Initialize(parameterSets);
            _auxC.Initialize(parameterSets);

            // デフォルトで [Aux-0] を選択する
            _auxA.SelectedEffectIndex = 0;
        }

        private EffectAuxBusControl GetTargetControl(ToolSoundAuxBusType busType)
        {
            switch (busType)
            {
                case ToolSoundAuxBusType.AuxBusType_AuxA:
                    return _auxA;

                case ToolSoundAuxBusType.AuxBusType_AuxB:
                    return _auxB;

                case ToolSoundAuxBusType.AuxBusType_AuxC:
                    return _auxC;

                default:
                    Debug.Assert(false);
                    break;
            }

            return null;
        }

        private void DispatchSelectChangedEvent()
        {
            // 選択が解除された場合は、直後に選択されるはずなので通知しない
            if (uint.MaxValue == SelectedControl.SelectedEffectIndex) { return; }

            // イベント通知
            if (null != EffectSelectChanged)
            {
                EffectSelectChanged(this, new EventArgs());
            }
        }

        #endregion
    }
}
