﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class EffectChorusPrameterControl : EffectParameterControl
    {
        public EffectChorusPrameterControl()
        {
            InitializeComponent();
        }

        #region ** プロパティ

        /// <summary>
        /// 関連付けられたパラメータを取得します。
        /// </summary>
        private new Preview.ChorusParameter Parameter
        {
            get
            {
                Debug.Assert(base.Parameter is Preview.ChorusParameter);
                return base.Parameter as Preview.ChorusParameter;
            }
        }

        #endregion

        #region ** イベントハンドラ

        private void OnDelayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.DelayTime = (float)target.Value;
        }

        private void OnDepthValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Depth = (float)target.Value;
        }

        private void OnRateValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Rate = (float)target.Value;
        }

        private void OnFeedbackValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Feedback = (float)target.Value;
        }

        private void OnOutGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.OutGain = (float)target.Value;
        }

        #endregion

        #region ** イベントハンドラのオーバーライド

        public override void OnParameterChanged(object sender, EventArgs e)
        {
            _delayTimeEdit.Value = Convert.ToDecimal(Parameter.DelayTime);
            _depthEdit.Value = Convert.ToDecimal(Parameter.Depth);
            _rateEdit.Value = Convert.ToDecimal(Parameter.Rate);
            _feedbackEdit.Value = Convert.ToDecimal(Parameter.Feedback);
            _outGainEdit.Value = Convert.ToDecimal(Parameter.OutGain);

            base.OnParameterChanged(sender, e);
        }

        #endregion
    }
}
