﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using FileFormats;
    using Framework;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using NintendoWare.ToolDevelopmentKit;
    using System;
    using FrameworkResources = NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// WindowsFormsベースのCommon向けUI機能を提供します。
    /// </summary>
    public class FormsUIServiceCommon : FormsUIService
    {
        /// <summary>
        ///
        /// </summary>
        public override ListConfigurationApplier CreateListConfigurationApplier(ListHeaderAdapterDictionary headerAdapters)
        {
            return new ListConfigurationApplierCommon(headerAdapters);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnDocumentImporting(object sender, DocumentImportEventArgs e)
        {
            Ensure.Argument.True(e.Documents.Length == 1);

            string message = FrameworkResources.MessageResource.Message_ConfirmImportLegacySoundProject;
            if (e.Documents[0] is BankRvlDocument || // RVL
                e.Documents[0] is BankDocument)      // CTR
            {
                message = FrameworkResources.MessageResource.Message_ConfirmImportLegacyBank;
            }

            if (e.Documents[0] is SoundSetRvlDocument || // RVL
                e.Documents[0] is SoundSetDocument)      // CTR
            {
                message = FrameworkResources.MessageResource.Message_ConfirmImportLegacySoundSet;
            }

            if (this.ShowMessageBox(
                string.Format(message, e.Documents[0].Resource.Key),
                AppMessageBoxButton.YesNo,
                AppMessageBoxImage.Question
                ) != AppMessageBoxResult.Yes)
            {
                e.Cancel = true;
                return;
            }
        }

        protected override void OnRaiseProjectSettingsChanged(EventArgs e)
        {
            base.OnRaiseProjectSettingsChanged(e);

            WaveFileManager.Instance.PreprocessExePath = ApplicationBase.Instance.GetWavePreprocessExeFullPath();
        }

        /// <summary>
        /// メインウィンドウを作成します。
        /// </summary>
        /// <returns>作成されたメインウィンドウ。</returns>
        protected override MainWindow CreateMainWindow()
        {
            return new MainWindowCommon();
        }
    }
}
