﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

using NintendoWare.SoundFoundation.CommandHandlers;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Operations;
using NintendoWare.SoundFoundation.Parameters;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Commands;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows;
using NintendoWare.SoundMaker.Windows.Forms;

namespace NintendoWare.SoundMaker.Windows.Forms.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// SoundPlayer ハンドラ
    /// </summary>
    public class RunTargetPlayerHandler : CommandHandler
    {
        public RunTargetPlayerHandler()
        {
        }

        public override string TargetCommandID
        {
            get { return "Preview.RunTargetPlayer"; }
        }

        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            return FormsApplicationCommon.Instance.CanRunTargetPlayer();
        }

        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            return FormsApplicationCommon.Instance.RunTargetPlayer();
        }
    }
}
