﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Resources
{
    using System.IO;
    using System.Text;

    internal class FileResourcesProxy
    {
        internal static string AppConfigurationToolPagesDefaultCommon
        {
            get { return GetUtf8String("AppConfigurationToolPagesDefaultCommon"); }
        }

        internal static string AppConfigurationWindowsDefaultCommon
        {
            get { return GetUtf8String("AppConfigurationWindowsDefaultCommon"); }
        }

        internal static string OptionConfigurationDefaultCommon
        {
            get { return GetUtf8String("OptionConfigurationDefaultCommon"); }
        }

        internal static string PreviewConfigurationDefaultCommon
        {
            get { return GetUtf8String("PreviewConfigurationDefaultCommon"); }
        }

        internal static string SchemaOptionConfigurationCommon
        {
            get { return GetUtf8String("SchemaOptionConfigurationCommon"); }
        }

        internal static string SoundProjectConfigurationDefaultCommon
        {
            get { return GetUtf8String("SoundProjectConfigurationDefaultCommon"); }
        }

        internal static string SoundProjectConfigurationListsDefaultCommon
        {
            get { return GetUtf8String("SoundProjectConfigurationListsDefaultCommon"); }
        }

        private static string GetUtf8String(string resourceName)
        {
            using (var reader = new StreamReader(
                new MemoryStream((byte[])FileResources.ResourceManager.GetObject(resourceName, FileResources.Culture)),
                Encoding.UTF8))
            {
                return reader.ReadToEnd();
            }
        }
    }
}
