﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Windows.Forms;
    using NintendoWare.SoundMakerPlugin;

    public class PreviewWaveSound : PreviewSound
    {
        private IPreviewWaveChannel _channel = null;
        private bool _forceNoLoop = false;

        public PreviewWaveSound(WaveSoundBase sound, OutputWaveFileRenderType samplingRate, bool forceNoLoop) : base(sound, samplingRate)
        {
            _forceNoLoop = forceNoLoop;
        }

        #region ** プロパティ

        public override PreviewPlayerState State
        {
            get
            {
                if (null == _channel) { return PreviewPlayerState.Stopped; }
                return _channel.State;
            }
        }

        protected new WaveSoundBase Sound
        {
            get { return base.Sound as WaveSoundBase; }
        }

        #endregion

        #region ** メソッド

        public override void Prepare()
        {
            Stop();

            _channel = SoundMakerPluginManager.Instance.CurrentSoundMakerPlugin.CreatePreviewWaveChannel(Sound, this.RendererType, _forceNoLoop);
        }

        /// <summary>
        /// 再生
        /// </summary>
        public override void Play()
        {
            if (null == _channel) { throw new ApplicationException("invalid channel."); }
            _channel.Start();
        }

        /// <summary>
        /// 一時停止
        /// </summary>
        public override void Pause(bool flag)
        {
            if (null == _channel) { throw new ApplicationException("invalid channel."); }
            _channel.Pause(flag);
        }

        /// <summary>
        /// 停止
        /// </summary>
        public override void Stop()
        {
            if (null == _channel) { return; }
            _channel.Stop();
        }

        /// <summary>
        ///
        /// </summary>
        public override void SetParameter(string parameterName)
        {
            if (this._channel == null)
            {
                return;
            }

            float volume = (float)Sound.Volume / 127.0f;
            this._channel.ChannelSetUserVolume(volume);
        }

        /// <summary>
        ///
        /// </summary>
        public override void Dispose()
        {
            if (_channel != null)
            {
                _channel.Dispose();
            }
        }

        #endregion
    }
}
