﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Text;
    using System.Threading;
    using NintendoWare.SoundMaker.Preview.MCS;

    public abstract class PreviewWatcher : IDisposable
    {
        // ユーティリティ
        private Timer _syncTimer = null;    // 同期タイマー

        // 状態
        private bool _disposed = false;     // 破棄されたら true

        protected abstract int Period { get; }

        protected abstract bool IsSynchronized { get; }

        public void Reset()
        {
            if (null != _syncTimer)
            {
                _syncTimer.Dispose();
                _syncTimer = null;
            }

            // 同期しない場合は、ここまで
            if (!IsSynchronized) { return; }


            // タイマーを開始する
            _syncTimer = new Timer(OnInternalTimer, null, 0, Period);
        }

        public virtual void Dispose()
        {
            _disposed = true;

            if (null != _syncTimer)
            {
                _syncTimer.Dispose();
                _syncTimer = null;
            }

            OnDispose();
        }

        protected abstract void OnTimer(object state);

        protected virtual void OnDispose() { }

        private void OnInternalTimer(object state)
        {
            if (null == PreviewManager.Instance.InvokeControl) { return; }
            PreviewManager.Instance.InvokeControl.BeginInvoke(new TimerCallback(OnTimerInternal), new object[] { state });
        }

        private void OnTimerInternal(object state)
        {
            if (_disposed) { return; }
            OnTimer(state);
        }
    }
}
