﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.Alto.Foundation.Communications
{
    using System.Threading;

    public interface IComEndPoint
    {
        /// <summary>
        /// 接続の有無を取得します。
        /// </summary>
        bool IsConnected { get; }

        /// <summary>
        /// エンディアンを取得します。
        /// </summary>
        bool IsLittleEndian { get; }

        //-----------------------------------------------------------------

        /// <summary>
        /// 接続を開始します。
        /// </summary>
        /// <param name="syncContext">同期コンテキストを指定します。</param>
        void Connect(SynchronizationContext syncContext);

        /// <summary>
        /// 切断します。
        /// </summary>
        void Disconnect();

        /// <summary>
        /// チャンネルを開きます。
        /// </summary>
        /// <param name="port">ポートを指定します。</param>
        /// <returns>開いたチャンネルを返します。</returns>
        IComChannel OpenChannel(object port);
    }
}
