﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Preview.Htcs.Viewer
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Viewer;

    internal class HtcsGetSeqVariablesPacket : ViewerPacket
    {
        private static SeqVariableContainerCollection _variableSets = null;
        private static bool _received = true;

        #region ** プロパティ

        public static SeqVariableContainerCollection Target
        {
            get { return _variableSets; }
            set { _variableSets = value; }
        }

        public static bool Received
        {
            get { return _received; }
            set { _received = value; }
        }

        #endregion

        #region ** プロパティのオーバーライド

        /// <summary>
        /// パケットの種類
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.TOOL_SOUND_GET_SEQVARIABLES; }
        }

        #endregion

        #region ** メソッドのオーバーライド

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">対象ストリーム</param>
        /// <param name="header">パケットヘッダ</param>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            if (null == _variableSets)
            {
                reader.ReadBytes((int)header.Size);
                _received = true;
                return;
            }

            // シーケンス変数取得用ヘッダを解析する
            ToolSoundItemContainer container = new ToolSoundItemContainer();
            container.Read(reader);

            // シーケンス変数取得パラメータを解析する
            for (int i = 0; i < _variableSets.Count; i++)
            {
                _variableSets[i].Read(reader);
            }

            _received = true;
        }

        #endregion
    }
}
