﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

// タイムアウトを利用した読み込み待ちを行うかどうか
//#define USE_TIMEOUT

using System;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace NintendoWare.Generic.Preview.Htcs.Viewer
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Tool;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Viewer;

    /// <summary>
    /// ビューア接続
    /// <para>
    /// ビューアからツールに送られるパケットを処理する接続です。
    /// </para>
    /// </summary>
    public class HtcsViewerConnection : HtcsConnection
    {
        // 読み込み間隔
        private const int interval = 100;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public HtcsViewerConnection() { }

        /// <summary>
        /// チャンネルの取得。
        /// </summary>
        public override uint Channel
        {
#if ANIMATION
            get{ return _baseChannel + 0x3; }
#else
            get { return _baseChannel + 0x1; }
#endif
        }


        //---------------------------------------------------------------------
        /// <summary>
        /// メインループ。
        /// </summary>
        public override void MainLoop()
        {
            // ネットワークストリームのDataAvailableを利用した読み込み待ち
            if (!((NetworkStream)Reader.BaseStream).DataAvailable)
            {
                Thread.Sleep(interval);
                return;
            }
            CommPacketHeader header = new CommPacketHeader(Reader);
            Debug.Assert(!header.Error);

            ViewerPacket packet = ViewerPacket.Create(header);
            packet.Read(Reader, header);
            //ShowMessage( "  Viewer ← " + packet );
            if (packet.Reply)
            {
                CommPacketHeader replyHeader = packet.Write(Writer);
                Writer.Flush();
                //ShowMessage( "       → " + replyHeader );
            }
        }

    }
}
