﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview.Htcs.Tool.Sound
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Text;

    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Tool;
    using NW4F.ProtocolSound;
    using NW4R.ProtocolSound;
    using FrameworkResources = NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public class HtcsSetOutputModePacket : ToolSoundPacket
    {
        private ToolSoundOutputMode mainOutputMode = ToolSoundOutputMode.OutputMode_Invalid;
        private ToolSoundOutputMode drcOutputMode = ToolSoundOutputMode.OutputMode_Invalid;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="outputMode">出力モード</param>
        public HtcsSetOutputModePacket(ToolSoundOutputMode mainOutputMode, ToolSoundOutputMode drcOutputMode)
        {
            this.mainOutputMode = mainOutputMode;
            this.drcOutputMode = drcOutputMode;
        }

        #region ** プロパティのオーバーライド

        /// <summary>
        /// パケットの種類
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.TOOL_SOUND_SET_SYSTEMPARAMETERS; }
        }

        /// <summary>
        /// サイズ
        /// </summary>
        public override ushort Size
        {
            get
            {
                return (ushort)ToolSoundOutputModeParameters.StructSize;
            }
        }

        #endregion

        #region ** メソッド

        /// <summary>
        /// パケットを送信します。
        /// </summary>
        /// <param name="outputMode">出力モード</param>
        public static void Send(ToolSoundOutputMode mainOutputMode, ToolSoundOutputMode drcOutputMode)
        {
            if (CommManager.Instance != null && !CommManager.Instance.IsConnected) { return; }
            SendPacket(new HtcsSetOutputModePacket(mainOutputMode, drcOutputMode));
        }

        #endregion

        #region ** メソッドのオーバーライド

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">対象ストリーム</param>
        /// <param name="header">パケットヘッダ</param>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            // Write のみ
            Debug.Assert(false, "Don't call this method");
        }

        /// <summary>
        /// ストリームにデータを書き出します。
        /// </summary>
        /// <param name="writer">対象ストリーム</param>
        /// <returns>出力したパケットヘッダ</returns>
        public override CommPacketHeader Write(ProtocolSoundWriter writer)
        {
            Debug.Assert(null != writer, "Writer is null");

            // パケットヘッダを出力する
            CommPacketHeader header = CreateHeader();
            header.Write(writer);

            // パラメータを出力する
            ToolSoundOutputModeParameters parameters = new ToolSoundOutputModeParameters();
            parameters.mainOutputMode = this.mainOutputMode;
            parameters.drcOutputMode = this.drcOutputMode;
            parameters.Write(writer);

            return header;
        }

        #endregion
    }
}
