﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Generic.Preview.Htcs.Ping
{
    using System;
    using System.Diagnostics;
    using System.Net;
    using System.Threading;
    //using FrameworkResources = AnimSoundMakerGeneric.Resources;

    //using NW4F.ProtocolSound;
    using NintendoWare.SoundMaker.Framework.Preview.Communications;

    /// <summary>
    /// Ping接続
    /// <para>
    /// ビューアが正常に動作していることを確認するための接続です。
    /// </para>
    /// </summary>
    public class HtcsPingConnection : HtcsConnection
    {
        //---------------------------------------------------------------------
        // 定数
        //---------------------------------------------------------------------
        // 確認間隔
        private const int interval = 500;
        // タイムアウト
        private const int timeout = 6000;

        //---------------------------------------------------------------------
        // 公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public HtcsPingConnection() { }

        /// <summary>
        /// 接続
        /// </summary>
        public override bool Connect(IPEndPoint ipEndPoint, string hostName)
        {
            _counter = 0;
            bool result = base.Connect(ipEndPoint, hostName);
            if (result)
            {
                ReceiveTimeout = timeout;
                SendTimeout = timeout;
            }
            return result;
        }

        /// <summary>
        /// メインループ
        /// </summary>
        public override void MainLoop()
        {
            // 呼びかける
            CommPacketHeader pingHeader = new CommPacketHeader(_counter, 0);
            //ShowMessage("    Ping " + pingHeader.ToString());
            pingHeader.Write(Writer);

            Thread.Sleep(interval);

            // 返り値をチェックする
            CommPacketHeader pongHeader = new CommPacketHeader(Reader);
            //ShowMessage("    Pong " + pongHeader.ToString());
            if ((pongHeader.PacketType != _counter) ||
                (pongHeader.Size != 0))
            {
                throw new Exception("Invalid ping replay {0}" +
                                     "\r\n" + _counter + " : " + pongHeader.ToString());
            }

            _counter++;
            if (_counter == Constants.HEADER_REPLY_FLAG) { _counter = 0; }
        }

        /// <summary>
        /// チャンネルの取得
        /// </summary>
        public override uint Channel
        {
#if ANIMATION
            get{ return _baseChannel + 0xe; }
#else
            get { return _baseChannel + 0xf; }
#endif
        }

        //---------------------------------------------------------------------
        // 非公開メンバ
        //---------------------------------------------------------------------
        // カウンタ
        private ushort _counter;
    }
}
