﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using NW4R.ProtocolSound;


namespace NintendoWare.Preview.HIO.Sound.Viewer
{
  //---------------------------------------------------------------------
  // 公開メンバ
  //---------------------------------------------------------------------
  /// <summary>
  /// MCSビューアパケット
  /// <para>
  /// ビューアからツールに送られるパケットのベースクラスです。
  /// </para>
  /// </summary>
  public abstract class HIOViewerPacket : HIOPacket
  {
    private static IViewerPacketFactoryCollection _factories = new IViewerPacketFactoryCollection();

    /// <summary>
    /// ビューアパケットの作成
    /// </summary>
    public static HIOViewerPacket Create(HIOPacketHeader header)
    {
      // 分類分けを行う
      HIOViewerPacket packet = null;

      foreach( IViewerPacketFactory factory in _factories ) {

        if( factory.Category != ( header.PacketType & Constants.HEADER_CATEGORY_MASK ) ) { continue; }

        packet = factory.CreatePacket( header );
        if( null != packet ) { return packet; }

      }

      switch( header.PacketType & Constants.HEADER_CATEGORY_MASK )
      {
        case Constants.CATEGORY_TEST:
#if false
          packet = MCSViewerTestPacket.CreateTestPacket(
            header.PacketType);
#endif
          break;
      }

      return packet;
    }

    //---------------------------------------------------------------------
    /// <summary>
    /// コンストラクタ
    /// </summary>
    protected HIOViewerPacket()
    {
      //Debug.Assert(!Error);
    }

    #region ** プロパティ

    public static IViewerPacketFactoryCollection Factories
    {
      get { return _factories; }
    }

    #endregion
  }

  #region ** パケットファクトリー

  public interface IViewerPacketFactory
  {
    #region ** プロパティ

    ushort Category { get; }

    #endregion

    #region ** メソッド

    HIOViewerPacket CreatePacket(HIOPacketHeader header);

    #endregion
  }

  #region ** コレクション

  public class IViewerPacketFactoryCollection : Collection<IViewerPacketFactory> { }

  #endregion

  #endregion
}
