﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using System;
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NW4R.ProtocolSound;

    public class ReverbHiConverter : EffectConverter<XmlReverbHi, ReverbHiParameter>
    {
        protected override void ApplyParameters(XmlReverbHi xmlEffect, ReverbHiParameter effectParameter)
        {
            effectParameter.EarlyMode = xmlEffect.EarlyMode;
            effectParameter.PreDelayTimeMax = xmlEffect.PreDelayTimeMax;
            effectParameter.PreDelayTime = xmlEffect.PreDelayTime;
            effectParameter.FusedMode = ConvertFusedMode(xmlEffect.FusedMode);
            effectParameter.FusedTime = xmlEffect.FusedTime;
            effectParameter.Coloration = xmlEffect.Coloration;
            effectParameter.Damping = xmlEffect.Damping;
            effectParameter.Crosstalk = xmlEffect.Crosstalk;
            effectParameter.EarlyGain = xmlEffect.EarlyGain;
            effectParameter.FusedGain = xmlEffect.FusedGain;
            effectParameter.OutGain = xmlEffect.OutGain;
        }

        protected override void ExtractParameters(ReverbHiParameter effectParameter, XmlReverbHi xmlEffect)
        {
            xmlEffect.EarlyMode = effectParameter.EarlyMode;
            xmlEffect.PreDelayTimeMax = effectParameter.PreDelayTimeMax;
            xmlEffect.PreDelayTime = effectParameter.PreDelayTime;
            xmlEffect.FusedMode = ConvertFusedMode(effectParameter.FusedMode);
            xmlEffect.FusedTime = effectParameter.FusedTime;
            xmlEffect.Coloration = effectParameter.Coloration;
            xmlEffect.Damping = effectParameter.Damping;
            xmlEffect.Crosstalk = effectParameter.Crosstalk;
            xmlEffect.EarlyGain = effectParameter.EarlyGain;
            xmlEffect.FusedGain = effectParameter.FusedGain;
            xmlEffect.OutGain = effectParameter.OutGain;
        }

        private ToolSoundFusedMode ConvertFusedMode(XmlReverbHiFusedMode fusedMode)
        {
            switch (fusedMode)
            {
                case XmlReverbHiFusedMode.OldAxfx:
                    return ToolSoundFusedMode.FusedMode_OldAxfx;

                case XmlReverbHiFusedMode.MetalTank:
                    return ToolSoundFusedMode.FusedMode_MetalTank;

                case XmlReverbHiFusedMode.SmallRoom:
                    return ToolSoundFusedMode.FusedMode_SmallRoom;

                case XmlReverbHiFusedMode.LargeRoom:
                    return ToolSoundFusedMode.FusedMode_LargeRoom;

                case XmlReverbHiFusedMode.Hall:
                    return ToolSoundFusedMode.FusedMode_Hall;

                case XmlReverbHiFusedMode.Cavernous:
                    return ToolSoundFusedMode.FusedMode_Cavernous;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        private XmlReverbHiFusedMode ConvertFusedMode(ToolSoundFusedMode fusedMode)
        {
            switch (fusedMode)
            {
                case ToolSoundFusedMode.FusedMode_OldAxfx:
                    return XmlReverbHiFusedMode.OldAxfx;

                case ToolSoundFusedMode.FusedMode_MetalTank:
                    return XmlReverbHiFusedMode.MetalTank;

                case ToolSoundFusedMode.FusedMode_SmallRoom:
                    return XmlReverbHiFusedMode.SmallRoom;

                case ToolSoundFusedMode.FusedMode_LargeRoom:
                    return XmlReverbHiFusedMode.LargeRoom;

                case ToolSoundFusedMode.FusedMode_Hall:
                    return XmlReverbHiFusedMode.Hall;

                case ToolSoundFusedMode.FusedMode_Cavernous:
                    return XmlReverbHiFusedMode.Cavernous;
            }

            throw new ApplicationException("invalid effect bus type.");
        }
    }
}
