﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NW4R.ProtocolSound;

    public class MultiChannelReverbConverter : EffectConverter<XmlMultiChannelReverb, MultiChannelReverbParameter>
    {
        protected override void ApplyParameters(XmlMultiChannelReverb xmlEffect, MultiChannelReverbParameter effectParameter)
        {
            effectParameter.EarlyMode = this.ConvertEarlyMode(xmlEffect.EarlyMode);
            effectParameter.LateMode = this.ConvertLateMode(xmlEffect.LateMode);
            effectParameter.PreDelayTime = xmlEffect.PreDelayTime;
            effectParameter.DecayTime = xmlEffect.DecayTime;
            effectParameter.HfDecayRatio = xmlEffect.HfDecayRatio;
            effectParameter.Coloration = xmlEffect.Coloration;
            effectParameter.EarlyGain = xmlEffect.EarlyGain;
            effectParameter.LateGain = xmlEffect.LateGain;
            effectParameter.ReverbGain = xmlEffect.ReverbGain;
        }

        protected override void ExtractParameters(MultiChannelReverbParameter effectParameter, XmlMultiChannelReverb xmlEffect)
        {
            xmlEffect.EarlyMode = this.ConvertEarlyMode(effectParameter.EarlyMode);
            xmlEffect.LateMode = this.ConvertLateMode(effectParameter.LateMode);
            xmlEffect.PreDelayTime = effectParameter.PreDelayTime;
            xmlEffect.DecayTime = effectParameter.DecayTime;
            xmlEffect.HfDecayRatio = effectParameter.HfDecayRatio;
            xmlEffect.Coloration = effectParameter.Coloration;
            xmlEffect.EarlyGain = effectParameter.EarlyGain;
            xmlEffect.LateGain = effectParameter.LateGain;
            xmlEffect.ReverbGain = effectParameter.ReverbGain;
        }

        private ToolSoundEarlyMode ConvertEarlyMode(XmlMultiChannelReverbEarlyMode earlyMode)
        {
            switch (earlyMode)
            {
                case XmlMultiChannelReverbEarlyMode.SmallRoom:
                    return ToolSoundEarlyMode.SmallRoom;

                case XmlMultiChannelReverbEarlyMode.LargeRoom:
                    return ToolSoundEarlyMode.LargeRoom;

                case XmlMultiChannelReverbEarlyMode.Hall:
                    return ToolSoundEarlyMode.Hall;

                case XmlMultiChannelReverbEarlyMode.Cavern:
                    return ToolSoundEarlyMode.Cavern;

                case XmlMultiChannelReverbEarlyMode.None:
                    return ToolSoundEarlyMode.None;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        private XmlMultiChannelReverbEarlyMode ConvertEarlyMode(ToolSoundEarlyMode earlyMode)
        {
            switch (earlyMode)
            {
                case ToolSoundEarlyMode.SmallRoom:
                    return XmlMultiChannelReverbEarlyMode.SmallRoom;

                case ToolSoundEarlyMode.LargeRoom:
                    return XmlMultiChannelReverbEarlyMode.LargeRoom;

                case ToolSoundEarlyMode.Hall:
                    return XmlMultiChannelReverbEarlyMode.Hall;

                case ToolSoundEarlyMode.Cavern:
                    return XmlMultiChannelReverbEarlyMode.Cavern;

                case ToolSoundEarlyMode.None:
                    return XmlMultiChannelReverbEarlyMode.None;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        private ToolSoundLateMode ConvertLateMode(XmlMultiChannelReverbLateMode lateMode)
        {
            switch (lateMode)
            {
                case XmlMultiChannelReverbLateMode.Room:
                    return ToolSoundLateMode.Room;

                case XmlMultiChannelReverbLateMode.Hall:
                    return ToolSoundLateMode.Hall;

                case XmlMultiChannelReverbLateMode.MetalCorridor:
                    return ToolSoundLateMode.MetalCorridor;

                case XmlMultiChannelReverbLateMode.Cavern:
                    return ToolSoundLateMode.Cavern;

                case XmlMultiChannelReverbLateMode.Maximun:
                    return ToolSoundLateMode.Maximun;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        private XmlMultiChannelReverbLateMode ConvertLateMode(ToolSoundLateMode lateMode)
        {
            switch (lateMode)
            {
                case ToolSoundLateMode.Room:
                    return XmlMultiChannelReverbLateMode.Room;

                case ToolSoundLateMode.Hall:
                    return XmlMultiChannelReverbLateMode.Hall;

                case ToolSoundLateMode.MetalCorridor:
                    return XmlMultiChannelReverbLateMode.MetalCorridor;

                case ToolSoundLateMode.Cavern:
                    return XmlMultiChannelReverbLateMode.Cavern;

                case ToolSoundLateMode.Maximun:
                    return XmlMultiChannelReverbLateMode.Maximun;
            }

            throw new ApplicationException("invalid effect bus type.");
        }
    }
}
