﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using System;
    using NintendoWare.SoundMaker.Configurations.Schemas;
    //using NW4R.ProtocolSound;

    public abstract class EffectConverter
    {
        public abstract Type XmlDataType { get; }

        public abstract Type DataType { get; }

        public abstract void Apply(XmlEffect xmlEffect, EffectParameter effectParameter);
        public abstract void Extract(EffectParameter effectParameter, XmlEffect xmlEffect);
    }

    public abstract class EffectConverter<TXmlEffect, TEffectParameter> : EffectConverter
        where TXmlEffect : XmlEffect
        where TEffectParameter : EffectParameter
    {
        public override Type XmlDataType
        {
            get { return typeof(TXmlEffect); }
        }

        public override Type DataType
        {
            get { return typeof(TEffectParameter); }
        }

        public override void Apply(XmlEffect xmlEffect, EffectParameter effectParameter)
        {
            if (!(xmlEffect is TXmlEffect))
            {
                throw new ArgumentException("invalid xml effect data type");
            }
            if (!(effectParameter is TEffectParameter))
            {
                throw new ArgumentException("invalid effect parameter data type");
            }

            ApplyParameters(xmlEffect as TXmlEffect, effectParameter as TEffectParameter);
        }

        public override void Extract(EffectParameter effectParameter, XmlEffect xmlEffect)
        {
            if (!(effectParameter is TEffectParameter))
            {
                throw new ArgumentException("invalid effect parameter data type");
            }
            if (!(xmlEffect is TXmlEffect))
            {
                throw new ArgumentException("invalid xml effect data type");
            }

            xmlEffect.BusType = EffectIDConverter.ConvertEffectBusType(effectParameter.EffectID.BusType);
            xmlEffect.Index = (int)effectParameter.EffectID.EffectIndex;

            ExtractParameters(effectParameter as TEffectParameter, xmlEffect as TXmlEffect);
        }

        protected abstract void ApplyParameters(TXmlEffect xmlEffect, TEffectParameter effectParameter);

        protected abstract void ExtractParameters(TEffectParameter effectParameter, TXmlEffect xmlEffect);
    }
}
