﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Resources;

    /// <summary>
    /// プレビュー関連コマンドを管理します。
    /// </summary>
    public static class PreviewCommonCommands
    {
        /// <summary>
        /// プレビュー関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(
                    typeof(PreviewCommonCommands),
                    BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// TargetPlayer を起動する。（実機版 Player）
        /// </summary>
        public static readonly Command RunTargetPlayer =
            new Command("Preview.RunTargetPlayer", MessageResource.Command_Preview_RunTargetPlayer_Name)
            {
                Text = "dummy",         // テキストをカスタマイズするには string.Empty 以外をここで設定しなければならない。
                ToolTipText = "dummy",  // これらのテキストはプラグインのテキストで再設定されます。
            };

        /// <summary>
        /// TargetPlayer を停止する。（実機版 Player）
        /// </summary>
        public static readonly Command ShutdownTargetPlayer =
            new Command("Preview.ShutdownTargetPlayer", MessageResource.Command_Preview_ShutdownTargetPlayer_Name)
            {
                Text = "dummy",         // テキストをカスタマイズするには string.Empty 以外をここで設定しなければならない。
                ToolTipText = "dummy",  // これらのテキストはプラグインのテキストで再設定されます。
            };

        /// <summary>
        /// SoundPlayer(PC版)を起動する。
        /// </summary>
        public static readonly Command RunPCSoundPlayer =
            new Command("Preview.RunPCSoundPlayer", MessageResource.Command_Preview_RunPCSoundPlayer_Name)
            {
                Text = MessageResource.Command_Preview_RunPCSoundPlayer_Text,
                ToolTipText = MessageResource.Command_Preview_RunPCSoundPlayer_ToolTipText,
                Image = ImageResource.BitmapIconRunPCSoundPlayer.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// AtkPlayer(PC版)を起動する。
        /// </summary>
        public static readonly Command RunPCAtkPlayer =
            new Command("Preview.RunPCAtkPlayer", MessageResource.Command_Preview_RunPCAtkPlayer_Name)
            {
                Text = MessageResource.Command_Preview_RunPCAtkPlayer_Text,
                ToolTipText = MessageResource.Command_Preview_RunPCAtkPlayer_ToolTipText,
                Image = ImageResource.BitmapIconRunPCAtkPlayer.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 接続する。
        /// </summary>
        public static readonly Command ConnectToTarget =
            new Command("Preview.ConnectToTarget", MessageResource.Command_Preview_ConnectToTarget_Name)
            {
                Text = MessageResource.Command_Preview_ConnectToTarget_Text,
                ToolTipText = MessageResource.Command_Preview_ConnectToTarget_ToolTipText,
                Image = ImageResource.BitmapIconConnectToSoundPlayer.MakeNewTransparent(UIServiceBase.TransparentColor),
                ShortcutKeyText = "F6",
            };

        /// <summary>
        /// 切断する。
        /// </summary>
        public static readonly Command DisconnectFromTarget =
            new Command("Preview.DisconnectFromTarget", MessageResource.Command_Preview_DisconnectFromTarget_Name)
            {
                Text = MessageResource.Command_Preview_DisconnectFromTarget_Text,
                ToolTipText = MessageResource.Command_Preview_DisconnectFromTarget_ToolTipText,
                Image = ImageResource.BitmapIconDisconnectFromSoundPlayer.MakeNewTransparent(UIServiceBase.TransparentColor),
                ShortcutKeyText = "F6",
            };
    }
}
