﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class StreamSoundTrack : StreamSoundTrackBase
    {
        /// <summary>
        /// センド設定を取得または設定します。
        /// </summary>
        public new SendsCommon Sends
        {
            get { return this.GetValue<SendsCommon>(ProjectParameterNames.Sound.Sends); }
            set { this.SetValue<SendsCommon>(ProjectParameterNames.Sound.Sends, value); }
        }

        /// <summary>
        ///
        /// </summary>
        public override ICloneable Clone()
        {
            StreamSoundTrack track = new StreamSoundTrack();

            foreach (string key in track.Parameters.Keys)
            {
                if (key == ProjectParameterNames.Sound.Sends)
                {
                    track.Sends = this.Sends.Clone() as SendsCommon;
                }
                else if (this.Parameters.ContainsKey(key) == true)
                {
                    track.Parameters[key].Value = this.Parameters[key].Value;
                }
            }

            return track;
        }

        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            //
            StreamSoundSendsParameterValue sendsParam =
                new StreamSoundSendsParameterValue(new SendsCommon());
            this.Parameters.RemoveValue(ProjectParameterNames.Sound.Sends);
            Parameters.AddValue(ProjectParameterNames.Sound.Sends, sendsParam);

            // sndedit 転送対象パラメータ
            this.SetParameterAttributes(ProjectParameterNames.Sound.Sends, ParameterAttributes.ComputeSndeditTransferHash);
        }
    }
}
