﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Operations
{
    using Nintendo.AudioToolkit.Operations;
    using System;
    using System.Diagnostics;

    /// <summary>
    /// OperationExecutorです。
    /// </summary>
    public class OperationExecutor : IOperationExecutor
    {
        private OperationHistory operationHistory = null;

        public OperationExecutor(OperationHistory operationHistory)
        {
            Debug.Assert(operationHistory != null);

            this.operationHistory = operationHistory;
        }

        void IOperationExecutor.ExecuteOperation(Action executeAction, Action rollbackAction)
        {
            if (this.operationHistory != null)
            {
                var operation = new ActionOperation(executeAction, rollbackAction);
                operation.Execute();
                this.operationHistory.AddOperation(operation);
            }
        }

        public void BeginTransaction()
        {
            if (this.operationHistory != null)
            {
                this.operationHistory.BeginTransaction();
            }
        }

        public void EndTransaction()
        {
            if (this.operationHistory != null)
            {
                this.operationHistory.EndTransaction();
            }
        }

        public void CancelTransaction()
        {
            if (this.operationHistory != null)
            {
                this.operationHistory.CancelTransaction();
            }
        }
    }
}
