﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.IO;

namespace NintendoWare.SoundFoundation.FileFormats.Wave
{
    using Nintendo.Atk.Binary;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.FileFormats.Audio;
    using NintendoWare.SoundFoundation.Resources;

    public class WaveFileOpusReader : WaveFileReader
    {
        private Stream strm;
        private string filePath;

        public override void Close()
        {
            strm.Close();
            filePath = null;
        }

        public override byte[] Read()
        {
            throw new NotSupportedException();
        }

        protected override void DisposeInternal()
        {
            if (strm != null)
            {
                strm.Close();
            }
            filePath = null;
        }

        protected override WaveDataStream CreateDataStream()
        {
            throw new NotSupportedException();
        }

        protected override WaveFile OpenInternal(string filePath)
        {
            try
            {
                return OpenOpus(filePath);
            }
            catch (Exception e)
            {
                if (e is WaveFileReaderException)
                {
                    throw e;
                }
                else
                {
                    this.filePath = null;

                    string message =
                        MessageResource.Message_InvalidWaveFile + " \"" + filePath + "\"";

                    throw new WaveFileReaderException(message);
                }
            }
        }

        private WaveFileOpus OpenOpus(string filePath)
        {
            AudioOpusBasicInfo info;

            strm = File.OpenRead(filePath);
            using (var reader = LittleEndianBinaryReader.Create(strm))
            {
                info = AudioOpusBasicInfo.FromBinary(reader);
            }

            WaveFileOpus waveFile = new WaveFileOpus()
            {
                ChannelCount = info.ChannelCount,
                SampleRate = info.SampleRate,
            };

            this.filePath = filePath;

            return waveFile;
        }
    }

    internal class WaveFileReaderException : WaveFileFormatException
    {
        public WaveFileReaderException(string s) : base(s) { }
    }
}
