﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("WaveSound", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlWaveSoundCommon : XmlComponent, IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // ウェーブサウンドパラメータ
        [XmlArrayItem(XmlParameterNames.ChannelPriority, Type = typeof(XmlChannelPriorityParam))]
        [XmlArrayItem(XmlParameterNames.Envelope.Release, Type = typeof(XmlEnvelopeReleaseParam))]
        [XmlArrayItem(XmlParameterNames.Pan, Type = typeof(XmlPanParam))]
        [XmlArrayItem(XmlParameterNames.PanCurve, Type = typeof(XmlPanCurveParam))]
        [XmlArrayItem(XmlParameterNames.PanMode, Type = typeof(XmlPanModeParam))]
        [XmlArrayItem(XmlParameterNames.Pitch, Type = typeof(XmlPitchParam))]
        [XmlArrayItem(XmlParameterNames.LPF, Type = typeof(XmlLPFParam))]
        [XmlArrayItem(XmlParameterNames.BiquadType, Type = typeof(XmlBiquadTypeParam))]
        [XmlArrayItem(XmlParameterNames.Biquad, Type = typeof(XmlBiquadParam))]
        [XmlArrayItem(XmlParameterNames.ReleasePriorityFixed, Type = typeof(XmlReleasePriorityFixedParam))]
        [XmlArrayItem(XmlParameterNames.Sends, Type = typeof(XmlSendsParam))]
        [XmlArrayItem(XmlParameterNames.SurroundPan, Type = typeof(XmlSurroundPanParam))]
        [XmlArrayItem(XmlParameterNames.WaveArchiveReference, Type = typeof(XmlWaveArchiveReferenceParam))]
        [XmlArrayItem(XmlParameterNames.WaveEncoding, Type = typeof(XmlWaveEncodingParam))]
        [XmlArrayItem(XmlParameterNames.IsResampleEnabled, Type = typeof(XmlIsResampleEnabledParam))]
        [XmlArrayItem(XmlParameterNames.SampleRate, Type = typeof(XmlSampleRateParam))]
        [XmlArrayItem(XmlParameterNames.IsDownMixEnabled, Type = typeof(XmlIsDownMixEnabledParam))]
        [XmlArrayItem(XmlParameterNames.FrontBypass, Type = typeof(XmlFrontBypassParam))]
        [XmlArrayItem(XmlParameterNamesCommon.RemoteFilter, Type = typeof(XmlRemoteFilterParam))]
#if false
        [XmlArrayItem(XmlParameterNames.LoopType, Type = typeof(XmlLoopTypeParam))]
        [XmlArrayItem(XmlParameterNames.LoopStartFrame, Type = typeof(XmlLoopStartFrameParam))]
        [XmlArrayItem(XmlParameterNames.LoopEndFrame, Type = typeof(XmlLoopEndFrameParam))]
#endif
        // サウンドパラメータ
        [XmlArrayItem(XmlParameterNames.ActorPlayer, Type = typeof(XmlActorPlayerParam))]
        [XmlArrayItem(XmlParameterNames.FilePath, Type = typeof(XmlFilePathParam))]
        [XmlArrayItem(XmlParameterNames.PlayerPriority, Type = typeof(XmlPlayerPriorityParam))]
        [XmlArrayItem(XmlParameterNames.PlayerReference, Type = typeof(XmlPlayerReferenceParam))]
        [XmlArrayItem(XmlParameterNames.Volume, Type = typeof(XmlVolumeParam))]
        [XmlArrayItem(XmlParameterNames.UserParameter, Type = typeof(XmlUserParameterParam))]
        [XmlArrayItem(XmlParameterNames.UserParameter1, Type = typeof(XmlUserParameter1Param))]
        [XmlArrayItem(XmlParameterNames.UserParameter2, Type = typeof(XmlUserParameter2Param))]
        [XmlArrayItem(XmlParameterNames.UserParameter3, Type = typeof(XmlUserParameter3Param))]
        [XmlArrayItem(XmlParameterNames.Sound3DParams, Type = typeof(XmlSound3DParam))]
        [XmlArrayItem(XmlParameterNames.SinglePlayType, Type = typeof(XmlSinglePlayTypeParam))]
        [XmlArrayItem(XmlParameterNames.SinglePlayEffectiveDuration, Type = typeof(XmlSinglePlayEffectiveDurationParam))]
        // コンポーネントパラメータ
        [XmlArrayItem(XmlParameterNames.ColorIndex, Type = typeof(XmlColorIndexParam))]
        [XmlArrayItem(XmlParameterNames.Comment, Type = typeof(XmlCommentParam))]
        [XmlArrayItem(XmlParameterNames.Comment1, Type = typeof(XmlComment1Param))]
        [XmlArrayItem(XmlParameterNames.Comment2, Type = typeof(XmlComment2Param))]
        [XmlArrayItem(XmlParameterNames.Comment3, Type = typeof(XmlComment3Param))]
        [XmlArrayItem(XmlParameterNames.Comment4, Type = typeof(XmlComment4Param))]
        [XmlArrayItem(XmlParameterNames.Comment5, Type = typeof(XmlComment5Param))]
        [XmlArrayItem(XmlParameterNames.Comment6, Type = typeof(XmlComment6Param))]
        [XmlArrayItem(XmlParameterNames.Comment7, Type = typeof(XmlComment7Param))]
        [XmlArrayItem(XmlParameterNames.Comment8, Type = typeof(XmlComment8Param))]
        [XmlArrayItem(XmlParameterNames.Comment9, Type = typeof(XmlComment9Param))]
        [XmlArrayItem(XmlParameterNames.IsEnabled, Type = typeof(XmlIsEnabledParam))]
        // カスタムパラメータ
        [XmlArrayItem(XmlParameterNames.Custom.Bool, Type = typeof(XmlBoolParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Float, Type = typeof(XmlFloatParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Int, Type = typeof(XmlIntParam))]
        [XmlArrayItem(XmlParameterNames.Custom.String, Type = typeof(XmlStringParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Uint, Type = typeof(XmlUintParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Ulong, Type = typeof(XmlUlongParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Xml, Type = typeof(XmlXmlParam))]
        [XmlArrayItem(XmlParameterNames.Custom.ItemReference, Type = typeof(XmlItemReferenceParam))]
        public List<XmlParameter> Parameters { get; set; }
    }
}
