﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Xml;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;

    [Serializable]
    [XmlRoot(
        ElementName,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public sealed class XmlSoundSetFileCommon : XmlCommonFileRoot<XmlSoundSetFileBodyCommon>
    {
        private const string ElementName = "SoundSet";

        /// <summary>
        /// XMLデータを検証します。
        /// </summary>
        /// <param name="reader">対象となる XmlReader を指定します。</param>
        /// <param name="platform">プラットフォーム名を指定します。</param>
        public static void Validate(XmlReader reader, string platform, string version)
        {
            Ensure.Argument.NotNull(reader);
            Ensure.Argument.NotNull(platform);

            XmlCommonFileRoot<XmlSoundSetFileBodyCommon>.Validate(reader, ElementName, platform, version, ElementName);
        }
    }
}
