﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterUInt32 : IParameterValue
    {
        private UInt32 value;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 Value
        {
            get { return value; }
            set
            {
                this.value = value;
            }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        object IParameterValue.Value
        {
            get { return this.Value; }
            set
            {
                Ensure.Argument.True(value is UInt32);
                this.Value = (UInt32)value;
            }
        }
    }
}
