﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterReference<TValue> : IParameterValue
        where TValue : class
    {
        private TValue value;

        public ParameterReference(TValue value)
        {
            this.Value = value;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(OriginTag = "Element", HasOffset = true)]
        public TValue Value
        {
            get { return value; }
            set
            {
                Ensure.Argument.True(value == null || value is TValue);
                this.value = value as TValue;
            }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        object IParameterValue.Value
        {
            get { return this.Value; }
            set
            {
                if (value == null)
                {
                    this.Value = null;
                    return;
                }

                Ensure.Argument.True(value is TValue);
                this.Value = value as TValue;
            }
        }
    }
}
