﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterPan : ParameterBytes
    {
        private const int PanIndex = 0;
        private const int SurroundPanIndex = 1;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte Pan
        {
            get { return this.Bytes[PanIndex]; }
            set { this.Bytes[PanIndex] = value; }
        }

        [DomIgnoreField]
        public Byte SurroundPan
        {
            get { return this.Bytes[SurroundPanIndex]; }
            set { this.Bytes[SurroundPanIndex] = value; }
        }
    }
}
