﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterSends
    {
        private Byte[] fxSends = new Byte[0];
        private Byte[] padding = new Byte[0];

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Byte MainSend { get; set; }

        public Byte FxSendCount
        {
            get { return (Byte)this.fxSends.Length; }
        }

        public Byte[] FxSends
        {
            get { return this.fxSends; }
            set
            {
                this.fxSends = value;
                UpdatePadding();
            }
        }

        /// <summary>
        /// 4 バイトアライメントのためのパディングです。
        /// </summary>
        public Byte[] Padding
        {
            get { return this.padding; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        private void UpdatePadding()
        {
            padding = new Byte[4 - ((this.fxSends.Length + 2) % 4)];
        }
    }
}
