﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    internal enum ElementType : ushort
    {
        Category_Tables = 0x0100,
        Category_Parameters = 0x0200,
        Category_Codecs = 0x0300,
        Category_General = 0x1f00,

        Category_SoundArchiveFile_Blocks = 0x2000,
        Category_SoundArchiveFile_InfoSections = 0x2100,
        Category_SoundArchiveFile_ItemInfos = 0x2200,
        Category_SoundArchiveFile_Parameters = 0x2300,
        Category_SoundArchiveFile_General = 0x2400,

        Category_StreamSoundFile_Blocks = 0x4000,
        Category_StreamSoundFile_ItemInfos = 0x4100,

        Category_WaveSoundFile_Blocks = 0x4800,
        Category_WaveSoundFile_ItemInfos = 0x4900,

        Category_SequenceSoundFile_Blocks = 0x5000,
        Category_SequenceSoundFile_ItemInfos = 0x5100,

        Category_BankFile_Blocks = 0x5800,
        Category_BankFile_Items = 0x5900,
        Category_BankFile_ItemTables = 0x6000,

        Category_WaveArchiveFile_Blocks = 0x6800,

        Category_WaveFile_Blocks = 0x7000,
        Category_WaveFile_ItemInfos = 0x7100,

        Category_GroupFile_Blocks = 0x7800,
        Category_GroupFile_ItemInfos = 0x7900,

        Category_AnimSoundFile_Blocks = 0x8000,
        Category_AnimSoundFile_Items = 0x8100,

        //-----------------------------------------------------------------
        // サウンド共通
        //-----------------------------------------------------------------

        Table_EmbeddingTable = Category_Tables,
        Table_ReferenceTable,
        Table_ReferenceWithSizeTable,

        Parameter_Sound3D = Category_Parameters,
        Parameter_Sends,
        Parameter_Envelope,
        Parameter_AdshrEnvelope,

        Codec_DspAdpcmInfo = Category_Codecs,
        Codec_ImaAdpcmInfo,
        Codec_DspAdpcmContext,

        General_ByteStream = Category_General,
        General_String,

        //-----------------------------------------------------------------
        // サウンドアーカイブファイル
        //-----------------------------------------------------------------

        SoundArchiveFile_StringBlock = Category_SoundArchiveFile_Blocks,
        SoundArchiveFile_InfoBlock,
        SoundArchiveFile_FileBlock,

        SoundArchiveFile_SoundInfoSection = Category_SoundArchiveFile_InfoSections,
        SoundArchiveFile_BankInfoSection,
        SoundArchiveFile_PlayerInfoSection,
        SoundArchiveFile_WaveArchiveInfoSection,
        SoundArchiveFile_SoundGroupInfoSection,
        SoundArchiveFile_GroupInfoSection,
        SoundArchiveFile_FileInfoSection,

        SoundArchiveFile_SoundInfo = Category_SoundArchiveFile_ItemInfos,
        SoundArchiveFile_StreamSoundInfo,
        SoundArchiveFile_WaveSoundInfo,
        SoundArchiveFile_SequenceSoundInfo,
        SoundArchiveFile_SoundGroupInfo,
        SoundArchiveFile_WaveSoundGroupInfo,
        SoundArchiveFile_BankInfo,
        SoundArchiveFile_WaveArchiveInfo,
        SoundArchiveFile_GroupInfo,
        SoundArchiveFile_PlayerInfo,
        SoundArchiveFile_FileInfo,
        SoundArchiveFile_SoundArchivePlayerInfo,
        SoundArchiveFile_InternalFileInfo,
        SoundArchiveFile_ExternalFileInfo,
        SoundArchiveFile_StreamSoundTrackInfo,
        SoundArchiveFile_SendInfo,
        SoundArchiveFile_StreamSoundExtensionInfo,

        SoundArchiveFile_StringTable = Category_SoundArchiveFile_General,
        SoundArchiveFile_PatriciaTree,

        //-----------------------------------------------------------------
        // ストリームファイル
        //-----------------------------------------------------------------

        StreamSoundFile_InfoBlock = Category_StreamSoundFile_Blocks,
        StreamSoundFile_SeekBlock,
        StreamSoundFile_DataBlock,
        StreamSoundFile_RegionBlock,
        StreamSoundFile_PrefetchDataBlock,
        StreamSoundFile_MarkerBlock,

        StreamSoundFile_StreamSoundInfo = Category_StreamSoundFile_ItemInfos,
        StreamSoundFile_TrackInfo,
        StreamSoundFile_ChannelInfo,
        StreamSoundFile_RegionInfo,
        StreamSoundFile_MarkerInfo,

        //-----------------------------------------------------------------
        // ウェーブサウンドファイル
        //-----------------------------------------------------------------

        WaveSoundFile_InfoBlock = Category_WaveArchiveFile_Blocks,

        WaveSoundFile_WaveSoundMetaData = Category_WaveSoundFile_ItemInfos,
        WaveSoundFile_WaveSoundInfo,
        WaveSoundFile_NoteInfo,
        WaveSoundFile_TrackInfo,
        WaveSoundFile_NoteEvent,

        //-----------------------------------------------------------------
        // 波形アーカイブファイル
        //-----------------------------------------------------------------

        WaveArchiveFile_InfoBlock = Category_WaveArchiveFile_Blocks,
        WaveArchiveFile_FileBlock,

        //-----------------------------------------------------------------
        // 波形ファイル
        //-----------------------------------------------------------------

        WaveFile_InfoBlock = Category_WaveFile_Blocks,
        WaveFile_DataBlock,

        WaveFile_ChannelInfo = Category_WaveFile_ItemInfos,

        //-----------------------------------------------------------------
        // シーケンスファイル
        //-----------------------------------------------------------------

        SequenceSoundFile_DataBlock = Category_SequenceSoundFile_Blocks,
        SequenceSoundFile_LabelBlock,

        SequenceSoundFile_LabelInfo = Category_SequenceSoundFile_ItemInfos,

        //-----------------------------------------------------------------
        // バンクファイル
        //-----------------------------------------------------------------

        BankFile_InfoBlock = Category_BankFile_Blocks,

        BankFile_InstrumentInfo = Category_BankFile_Items,
        BankFile_KeyRegionInfo,
        BankFile_VelocityRegionInfo,
        BankFile_NullInfo,

        BankFile_DirectReferenceTable = Category_BankFile_ItemTables,
        BankFile_RangeReferenceTable,
        BankFile_IndexReferenceTable,

        //-----------------------------------------------------------------
        // グループファイル
        //-----------------------------------------------------------------

        GroupFile_InfoBlock = Category_GroupFile_Blocks,
        GroupFile_FileBlock,
        GroupFile_InfoExBlock,

        GroupFile_GroupItemInfo = Category_GroupFile_ItemInfos,
        GroupFile_GroupItemInfoEx,

        //-----------------------------------------------------------------
        // アニメーションサウンドファイル
        //-----------------------------------------------------------------
        AnimSoundFile_DataBlock = Category_AnimSoundFile_Blocks,

        AnimSoundFile_EventInfo = Category_AnimSoundFile_Items

        // C++用ヘッダファイルに変換した際に、
        // 実機コンパイラ (armcc) で警告が出るため enum の最後に , を付けないようにする
    }
}
