﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.IO;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.General_ByteStream)]
    internal class ByteStream
    {
        public ByteStream()
        {
        }

        public ByteStream(byte[] bytes)
        {
            if (bytes == null)
            {
                return;
            }

            this.Stream = new MemoryStream(bytes);
        }

        public ByteStream(byte[] bytes, int length)
        {
            if (bytes == null)
            {
                return;
            }

            Ensure.Operation.True(bytes.Length >= length);

            this.Stream = new MemoryStream(bytes, 0, length);
        }

        public ByteStream(Stream stream)
        {
            this.Stream = stream;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Stream Stream { get; set; }
    }
}
