﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal struct BinaryItemID
    {
        public static readonly BinaryItemID InvalidValue = new BinaryItemID(UInt32.MaxValue);

        private const UInt32 CategoryMask = 0xFF000000;
        private const UInt32 IndexMask = 0x00FFFFFF;

        private UInt32 value;

        //-----------------------------------------------------------------

        public BinaryItemID(UInt32 value)
        {
            this.value = value;
        }

        public BinaryItemID(ItemType type, UInt32 index)
        {
            this.value = InvalidValue.value;
            this.Type = type;
            this.Index = index;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 Value
        {
            get { return this.value; }
            set { this.value = value; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ItemType Type
        {
            get { return (ItemType)((this.Value & CategoryMask) >> 24); }
            set { this.Value &= ((UInt32)value << 24) | IndexMask; }
        }

        [DomIgnoreField]
        public UInt32 Index
        {
            get { return this.Value & IndexMask; }
            set
            {
                this.ValidateIndex(value);
                this.Value &= CategoryMask | value;
            }
        }

        //-----------------------------------------------------------------

        public static implicit operator BinaryItemID(UInt32 value)
        {
            return new BinaryItemID(value);
        }

        public static implicit operator BinaryItemID(ItemID value)
        {
            return new BinaryItemID(value.Value);
        }

        public static implicit operator UInt32(BinaryItemID value)
        {
            return value.Value;
        }

        public static implicit operator ItemID(BinaryItemID value)
        {
            return value.Value;
        }

        private void ValidateIndex(UInt32 index)
        {
            Ensure.Operation.True((index & CategoryMask) == 0);
        }
    }
}
