﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.WaveSoundElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.Table_ReferenceTable)]
    internal class TrackInfoList
    {
        private IList<TrackInfo> items = new List<TrackInfo>();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Int32 Count
        {
            get { return items.Count; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public IEnumerable<TrackInfo> Entries
        {
            get
            {
                return this.items;
            }
        }

        public IList<TrackInfo> Items
        {
            get
            {
                return this.items;
            }
        }
    }
}
