﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.WaveSoundElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.WaveSoundFile_NoteEvent)]
    internal class NoteEvent
    {
        public NoteEvent()
        {
            // デフォルト値を設定します。
            this.Position = 0.0f;
            this.Length = 0.0f;
            this.NoteIndex = 0;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Single Position { get; set; }

        public Single Length { get; set; }

        public UInt32 NoteIndex { get; set; }

        public UInt32 Reserved
        {
            get { return 0; }
        }
    }
}
