﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.WaveElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoBlockBody
    {
        private ReferenceTable<ChannelInfo> channelInfoEntries = new ReferenceTable<ChannelInfo>();
        private IList<ChannelInfo> channelInfos = new List<ChannelInfo>();

        public InfoBlockBody()
        {
            channelInfoEntries.Items = this.channelInfos;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomConvertTo(typeof(WaveEncoding2ByteConverter))]
        public WaveEncoding Encoding { get; set; }

        [DomConvertTo(typeof(Bool2ByteConverter))]
        public bool IsLoop { get; set; }

        public UInt16 Padding
        {
            get { return 0; }
        }

        public UInt32 SamplingRate { get; set; }

        public UInt32 LoopStart { get; set; }

        public UInt32 LoopEnd { get; set; }

        public UInt32 OriginalLoopStart { get; set; }

        public ReferenceTable<ChannelInfo> ChannelInfoEntries
        {
            get { return this.channelInfoEntries; }
        }

        public IList<ChannelInfo> ChannelInfos
        {
            get { return this.channelInfos; }
        }

        public IEnumerable<object> CodecInformations
        {
            get
            {
                foreach (ChannelInfo channelInfo in this.channelInfos)
                {
                    yield return channelInfo.CodecInformation;
                }
            }
        }
    }
}
