﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.IO;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;
    using WaveElements;

    [StructLayout(LayoutKind.Sequential)]
    internal class WaveBinary : SoundCommonFileRoot
    {
        private InfoBlock infoBlock = new InfoBlock();
        private DataBlock dataBlock = new DataBlock();

        public WaveBinary(
            string signature,
            byte majorVersion, byte minorVersion, byte microVersion, byte binaryBugFixVersion)
            : base(signature, majorVersion, minorVersion, microVersion, binaryBugFixVersion)
        {
            UpdateBlocks();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public CommonBlock<InfoBlockBody> InfoBlock
        {
            get { return this.infoBlock; }
        }

        [DomIgnoreField]
        public CommonBlock<DataBlockBody> FileBlock
        {
            get { return this.dataBlock; }
        }

        /// <summary>
        /// すべてのチャンネルデータストリームを列挙します。
        /// ここで列挙される順序が DATA ブロックに含まれるストリームの順序になります。
        /// </summary>
        [DomIgnoreField]
        private IEnumerable<ByteStream> ChannelDatas
        {
            get
            {
                foreach (ChannelInfo channelInfo in this.infoBlock.Body.ChannelInfos)
                {
                    yield return channelInfo.Data;
                }
            }
        }

        /// <summary>
        /// グループアイテム情報を追加します。
        /// </summary>
        /// <param name="item">追加するグループアイテム情報を指定します。</param>
        public void AddChannel(ChannelInfo channel)
        {
            Ensure.Argument.NotNull(channel);

            this.infoBlock.Body.ChannelInfos.Add(channel);
        }

        private void UpdateBlocks()
        {
            this.Blocks.Clear();

            this.Blocks.Add(this.infoBlock);
            this.Blocks.Add(this.dataBlock);

            this.dataBlock.Body.ChannelDatas = this.ChannelDatas;
        }
    }
}
