﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.StreamSoundElements;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWareBinary.StreamSoundElements;

    [StructLayout(LayoutKind.Sequential)]
    internal class StreamSoundPrefetchBinary : SoundCommonFileRoot
    {
        private InfoBlock infoBlock = new InfoBlock();
        private RegionBlock regionBlock = null;
        private PrefetchDataBlock prefetchDataBlock = new PrefetchDataBlock();

        public StreamSoundPrefetchBinary(
            string signature,
            byte majorVersion, byte minorVersion, byte microVersion, byte binaryBugFixVersion)
            : base(signature, majorVersion, minorVersion, microVersion, binaryBugFixVersion)
        {
            this.UpdateBlocks();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public InfoBlock InfoBlock
        {
            get { return this.infoBlock; }
        }

        [DomIgnoreField]
        public RegionBlock RegionBlock
        {
            get { return this.regionBlock; }
            set
            {
                this.regionBlock = value;
                this.UpdateBlocks();
            }
        }

        [DomIgnoreField]
        public PrefetchDataBlock PrefetchDataBlock
        {
            get { return this.prefetchDataBlock; }
        }

        private void UpdateBlocks()
        {
            this.Blocks.Clear();

            this.Blocks.Add(this.infoBlock);

            if (this.regionBlock != null)
            {
                this.Blocks.Add(this.regionBlock);
            }

            this.Blocks.Add(this.prefetchDataBlock);
        }
    }
}
