﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.StreamSoundElements
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class PrefetchDataBlockBody
    {
        public PrefetchDataBlockBody()
        {
            this.PrefetchDataEntries = new EmbeddingTable<PrefetchDataEntry>();
            this.PrefetchDataList = new List<PrefetchData>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public EmbeddingTable<PrefetchDataEntry> PrefetchDataEntries { get; private set; }

        [DomPreAlignment(64)]
        public List<PrefetchData> PrefetchDataList { get; private set; }
    }
}
