﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Collections.Generic;
    using System.Xml;
    using System.Xml.Serialization;

    /// <summary>
    /// 波形ファイルの情報を格納します。
    /// </summary>
    [Serializable]
    public class WaveFileXml
    {
        public WaveFileXml()
        {
        }

        /// <summary>
        /// ファイルパスを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public string FilePath { get; set; }

        /// <summary>
        /// バイナリファイルパスを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public string BinaryFilePath { get; set; }

        /// <summary>
        /// 参照数を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int ReferenceCount { get; set; }

        /// <summary>
        /// アーカイブ数を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int ArchiveCount { get; set; }

        [XmlArray("Users")]
        [XmlArrayItem("WaveFileUserWaveSound", typeof(WaveFileUserWaveSoundXml))]
        [XmlArrayItem("WaveFileUserVelocityRegion", typeof(WaveFileUserVelocityRegionXml))]
        public List<WaveFileUserComponentXml> Users { get; set; }

        [XmlArray("WaveArchives")]
        [XmlArrayItem("WaveArchive", typeof(WaveArchiveXml))]
        public List<WaveArchiveXml> WaveArchives { get; set; }
    }
}
