﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Xml;
    using System.Xml.Serialization;

    /// <summary>
    /// 波形ファイルを利用するベロシティリージョン情報を格納します。
    /// </summary>
    [Serializable]
    public class WaveFileUserVelocityRegionXml : WaveFileUserComponentXml
    {
        /// <summary>
        /// バンクファイルパスを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public string BankFilePath { get; set; }

        /// <summary>
        /// プログラム番号を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int ProgramNo { get; set; }

        /// <summary>
        /// キーを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Key { get; set; }

        /// <summary>
        /// ベロシティを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Velocity { get; set; }
    }
}
