﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Collections.Generic;
    using System.Globalization;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 要素マップアイテムを格納します。
    /// </summary>
    [Serializable]
    public class ElementMapItemXml
    {
        /// <summary>
        /// 16進数表記のアドレス（テキスト）を取得または設定します。
        /// </summary>
        [XmlAttribute("Address")]
        public string AddressText { get; set; }

        [XmlAttribute("Size")]
        public UInt32 Size { get; set; }

        [XmlAttribute("Name")]
        public string Name { get; set; }

        [XmlArray("Items")]
        [XmlArrayItem("ElementMapItem", typeof(ElementMapItemXml))]
        [XmlArrayItem("FileElementMapItem", typeof(FileElementMapItemXml))]
        public List<ElementMapItemXml> Items { get; set; }

        [XmlIgnore]
        public bool AddressTextSpecified
        {
            get { return this.Address != UInt32.MaxValue; }
        }

        [XmlIgnore]
        public bool SizeSpecified
        {
            get { return this.Size != UInt32.MaxValue; }
        }

        [XmlIgnore]
        public bool ItemsSpecified
        {
            get { return this.Items != null; }
        }

        /// <summary>
        /// 16進数表記のアドレス（数値）を取得または設定します。
        /// </summary>
        [XmlIgnore]
        internal UInt32 Address
        {
            get
            {
                if (this.AddressText == null || this.AddressText.Length == 0)
                {
                    return UInt32.MaxValue;
                }

                return UInt32.Parse(this.AddressText, NumberStyles.HexNumber);
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.AddressText = value.ToString("X8");
            }
        }
    }
}
