﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class SequenceSoundParameterArray : ParameterArray
    {
        private const int StartOffsetIndex = 0;
        private const int PriorityIndex = 1;

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ParameterUInt32 StartOffset
        {
            get { return GetValue<ParameterUInt32>(StartOffsetIndex); }
            set { SetValue(StartOffsetIndex, value); }
        }

        [DomIgnoreField]
        public ParameterSoundPriority Priority
        {
            get { return GetValue<ParameterSoundPriority>(PriorityIndex); }
            set { SetValue(PriorityIndex, value); }
        }
    }
}
