﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;
    using SoundArchiveElements;

    [StructLayout(LayoutKind.Sequential)]
    internal class SoundArchiveBinary : SoundCommonFileRoot
    {
        private readonly StringBlock stringBlock = new StringBlock();
        private readonly InfoBlock infoBlock = new InfoBlock();
        private readonly FileBlock fileBlock = new FileBlock();
        private bool excludeStringBlock = false;

        public SoundArchiveBinary(
            string signature,
            byte majorVersion, byte minorVersion, byte microVersion, byte binaryBugFixVersion)
            : base(signature, majorVersion, minorVersion, microVersion, binaryBugFixVersion)
        {
            this.Header.BlockReferencesWithSize = new List<CommonBlock>();
            UpdateBlocks();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public StringBlock StringBlock
        {
            get { return this.stringBlock; }
        }

        [DomIgnoreField]
        public InfoBlock InfoBlock
        {
            get { return this.infoBlock; }
        }

        [DomIgnoreField]
        public FileBlock FileBlock
        {
            get { return this.fileBlock; }
        }

        [DomIgnoreField]
        public bool ExcludeStringBlock
        {
            get { return this.excludeStringBlock; }
            set
            {
                this.excludeStringBlock = value;
                UpdateBlocks();
            }
        }

        private void UpdateBlocks()
        {
            this.Blocks.Clear();
            this.Header.BlockReferencesWithSize.Clear();

            if (!excludeStringBlock)
            {
                this.Blocks.Add(this.stringBlock);
            }

            this.Blocks.Add(this.infoBlock);
            this.Blocks.Add(this.fileBlock);

            if (this.Blocks == this.Header.BlockReferencesWithSize)
            {
                return;
            }

            this.Header.BlockReferencesWithSize.Add(this.stringBlock);
            this.Header.BlockReferencesWithSize.Add(this.infoBlock);
            this.Header.BlockReferencesWithSize.Add(this.fileBlock);
        }
    }
}
