﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.GroupElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoBlockBody
    {
        private IList<GroupItemInfo> items = new List<GroupItemInfo>();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 ItemCount
        {
            get { return (UInt32)this.Items.Count; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public IEnumerable<GroupItemInfo> ItemEntries
        {
            get { return this.Items; }
        }

        public IList<GroupItemInfo> Items
        {
            get { return items; }
        }
    }
}
