﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.BankFile_RangeReferenceTable)]
    internal class RangeReferenceTable
    {
        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 EntryCount
        {
            get { return (UInt32)this.Entries.Count; }
        }

        public IEnumerable<byte> EntryRanges
        {
            get
            {
                if (this.Entries.Count == 0)
                {
                    throw new Exception("internal error : invalid RangeReferenceTable.");
                }

                foreach (IInstrumentItem item in this.Entries)
                {
                    yield return item.RangeMax;
                }
            }
        }

        /// <summary>
        /// 4 バイトアライメントのためのパディングです。
        /// </summary>
        public Byte[] Padding
        {
            get
            {
                int remainder = this.Entries.Count % 4;

                if (remainder == 0)
                {
                    return new Byte[0];
                }

                return new Byte[4 - remainder];
            }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public virtual ICollection<IInstrumentItem> Entries { get; set; }
    }
}
