﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------


namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.BankFile_InstrumentInfo)]
    internal class InstrumentInfo : InstrumentItemSet<KeyRegionInfo>
    {
        private int programNo = 0;
        private string name = string.Empty;
        private bool isEnabled = true;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public int ProgramNo
        {
            get { return this.programNo; }
            set
            {
                this.programNo = value;
            }
        }

        /// <summary>
        /// インストルメントの名前を取得します。
        /// </summary>
        /// <remarks>
        /// バイナライズ処理に使用されますが、バイナリには出力されません。
        /// </remarks>
        [DomIgnoreField]
        public string Name
        {
            get { return this.name; }
            set { this.name = value; }
        }

        [DomIgnoreField]
        public bool IsEnabled
        {
            get { return this.isEnabled; }
            set { this.isEnabled = value; }
        }
    }
}
