﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using NintendoWare.SoundFoundation.Binarization;
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class ReferenceTable<TItem>
        where TItem : class
    {
        public ReferenceTable()
        {
            this.Items = new List<TItem>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        /// <summary>
        /// テーブルのアイテム数を取得します。
        /// </summary>
        public UInt32 ItemCount
        {
            get { return (UInt32)this.Items.Count; }
        }

        /// <summary>
        /// アイテムへの参照リストを出力するために、アイテムリストを取得します。
        /// </summary>
        [DomObjectReference(OriginTag = "Element", HasOffset = true)]
        public IList<TItem> Items { get; set; }
    }
}
