﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using Nintendo.Foundation.Collections;
    using NintendoWare.SoundFoundation.Binarization;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "BinaryRoot", "Element" })]
    internal abstract class BinaryFileRoot
    {
        private BinaryFileHeader header = new BinaryFileHeader();
        private ObservableList<BinaryBlock> blocks = new ObservableList<BinaryBlock>();

        protected BinaryFileRoot()
        {
            this.header.File = this;

            this.blocks.CollectionChanged += (sender, e) => this.UpdateBlockLinks();
        }

        protected BinaryFileRoot(string signature, Version version)
            : this()
        {
            Ensure.Argument.NotNull(signature);

            this.header.Signature = signature;
            this.header.MajorVersion = (byte)version.Major;
            this.header.MinorVersion = (byte)version.Minor;
            this.header.MicroVersion = (byte)version.Build;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomField("Header")]
        public BinaryFileHeader Header
        {
            get { return this.header; }
        }

        [DomField("Blocks")]
        [EnumeratedField(typeof(BinaryBlockNameProvider))]
        [DomPreAlignment(32)]
        public IList<BinaryBlock> Blocks
        {
            get { return this.blocks; }
        }

        //-----------------------------------------------------------------

        private void UpdateBlockLinks()
        {
            BinaryBlock nextBlock = null;

            this.Header.FirstBlockReference = this.blocks.FirstOrDefault();

            foreach (var block in this.blocks.Reverse())
            {
                block.Header.NextBlockReferenceForOffsetToNextBlock = nextBlock;
                nextBlock = block;
            }
        }
    }
}
