﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Parameters;

    public static class ConversionParameterNames
    {
        public const string AttachedGroups = "AttachedGroups@Temporary";
        public const string ID = "ID@Temporary";
        public const string IsUsed = "IsUsed@Temporary";
        public const string IsExcluded = "IsExcluded@Temporary";
        public const string OutputTarget = "OutputTarget@Temporary";
        public const string StringID = "StringID@Temporary";
        public const string TargetWaveArchive = "TargetWaveArchive@Temporary";
        public const string OriginalModel = "OriginalModel@Temporary";

        public static class StreamSound
        {
            public const string PrefetchOutputTarget = "StreamSound_Prefetch@Temporary";
            public const string TrackAllocationFlags = "StreamSound_TrackAllocationFlags";
            public const string TotalChannelCount = "StreamSound_TotalChannelCount";
            public const string ContainerType = "StreamSound_ContainerType";
            public const string LoopStartFrame = "StreamSound_LoopStartFrame";
            public const string LoopEndFrame = "StreamSound_LoopEndFrame";
            public const string HasLoop = "StreamSound_HasLoop";
            public const string BinaryFilePathForPartsConvert = "StreamSound_BinaryFilePathForPartsConvert";
            public const string PrefetchBinaryFilePathForPartsConvert = "StreamSound_PrefetchBinaryFilePathForPartsConvert";
            public const string PCBinaryFilePathForPartsConvert = "StreamSound_PCBinaryFilePathForPartsConvert";
            public const string WaveRegions = "StreamSound_WaveRegions@Temporary";
            public const string WaveMarkers = "StreamSound_WaveMarkers@Temporary";
        }

        public static class StreamSoundTrack
        {
            public const string ChannelCount = "StreamSoundTrack_ChannelCount";
        }

        public static class WaveSoundSet
        {
        }

        public static class WaveSound
        {
            public const string Index = "WaveSound_Index";
            public const string BinaryFilePathForPartsConvert = "WaveSound_BinaryFilePathForPartsConvert";
            public const string WaveArchiveBinaryFilePathForPartsConvert = "WaveSound_WaveArchiveBinaryFilePathForPartsConvert";
            public const string WaveSoundTrackConvertModels = "WaveSound_WaveSoundTrackConvertModels@Temporary";
            public const string WaveSoundClipConvertModels = "WaveSound_WaveSoundClipConvertModels@Temporary";
        }

        public static class SequenceSound
        {
            public const string StartOffset = "SequenceSound_StartOffset";
            public const string AllocateTrackFlags = "SequenceSound_AllocateTrackFlags";
            public const string BinaryFilePathForPartsConvert = "SequenceSound_BinaryFilePathForPartsConvert";
        }

        public static class SoundSetBank
        {
            public const string BinaryFilePathForPartsConvert = "SoundSetBank_BinaryFilePathForPartsConvert";
            public const string WaveArchiveBinaryFilePathForPartsConvert = "SoundSetBank_WaveArchiveBinaryFilePathForPartsConvert";
        }

        public static class WaveArchive
        {
            public const string Items = "WaveArchive_Items@Temporary";
            public const string ItemOutputTargets = "WaveArchiveItem_OutputTargets@Temporary";
        }

        public static class Group
        {
            public const string ItemFiles = "Group_ItemFiles@Temporary";
        }
    }
}
