﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using Core.Collections;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    internal static class WaveSoundSetEx
    {
        public static IDictionary<string, WaveArchiveBase> GetWaveArchiveDictionary(this WaveSoundSetBase waveSoundSet)
        {
            Ensure.Argument.NotNull(waveSoundSet);

            if (!waveSoundSet.Parameters.ContainsKey(ConversionParameterNames.TargetWaveArchive))
            {
                waveSoundSet.Parameters.AddValue(
                    ConversionParameterNames.TargetWaveArchive,
                    new ObjectParameterValue<IDictionary<string, WaveArchiveBase>>(new Dictionary<string, WaveArchiveBase>()));
            }

            return waveSoundSet.Parameters[ConversionParameterNames.TargetWaveArchive].Value as IDictionary<string, WaveArchiveBase>;
        }

        public static WaveArchiveBase GetWaveArchiveForGroup(this WaveSoundSetBase waveSoundSet, string groupName)
        {
            Ensure.Argument.NotNull(waveSoundSet);
            Ensure.Argument.NotNull(groupName);

            if (waveSoundSet.TargetWaveArchive != null)
            {
                return waveSoundSet.TargetWaveArchive;
            }

            IDictionary<string, WaveArchiveBase> waveArchiveDictionary = waveSoundSet.GetWaveArchiveDictionary();
            WaveArchiveBase waveArchive = null;

            if (waveArchiveDictionary.TryGetValue(groupName, out waveArchive))
            {
                return waveArchive;
            }

            if (waveArchiveDictionary.TryGetValue(string.Empty, out waveArchive))
            {
                return waveArchive;
            }

            return null;
        }
    }
}
