﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using Core.Parameters;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    internal static class SoundSetItemEx
    {
        public static uint GetStringID(this SoundSetItem soundSetItem)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.StringID))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.StringID, new UIntParameterValue(uint.MaxValue));
            }

            return (uint)soundSetItem.Parameters[ConversionParameterNames.StringID].Value;
        }

        public static void SetStringID(this SoundSetItem soundSetItem, uint value)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.StringID))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.StringID, new UIntParameterValue());
            }

            soundSetItem.Parameters[ConversionParameterNames.StringID].Value = value;
        }

        public static ICollection<GroupBase> GetAttachedGroups(this SoundSetItem soundSetItem)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.AttachedGroups))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.AttachedGroups,
                    new ObjectParameterValue<HashSet<GroupBase>>(new HashSet<GroupBase>()));
            }

            return soundSetItem.Parameters[ConversionParameterNames.AttachedGroups].Value
                as ICollection<GroupBase>;
        }

        public static bool GetIsUsed(this SoundSetItem soundSetItem)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.IsUsed))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.IsUsed,
                    new BoolParameterValue(false));
            }

            return (bool)soundSetItem.Parameters[ConversionParameterNames.IsUsed].Value;
        }

        public static void SetIsUsed(this SoundSetItem soundSetItem, bool isUsed)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.IsUsed))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.IsUsed,
                    new BoolParameterValue(false));
            }

            soundSetItem.Parameters[ConversionParameterNames.IsUsed].Value = isUsed;
        }

        public static SoundSetItem GetOriginalModel(this SoundSetItem soundSetItem)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.OriginalModel))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.OriginalModel, new ObjectParameterValue<SoundSetItem>(null));
            }

            return (SoundSetItem)soundSetItem.Parameters[ConversionParameterNames.OriginalModel].Value;
        }

        public static void SetOriginalModel(this SoundSetItem soundSetItem, SoundSetItem value)
        {
            Ensure.Argument.NotNull(soundSetItem);

            if (!soundSetItem.Parameters.ContainsKey(ConversionParameterNames.OriginalModel))
            {
                soundSetItem.Parameters.AddValue(
                    ConversionParameterNames.OriginalModel, new ObjectParameterValue<SoundSetItem>());
            }

            soundSetItem.Parameters[ConversionParameterNames.OriginalModel].Value = value;
        }
    }
}
