﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.IO;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    public static class SoundProjectDocumentEx
    {
        public static string GetDependFilePath(this SoundProjectDocument document, SoundSet addonSoundSet = null)
        {
            Ensure.Argument.NotNull(document);

            return Path.Combine(
                document.GetIntermediateOutputPath(),
                document.GetDependFileName(addonSoundSet));
        }

        public static string GetDependFileName(this SoundProjectDocument document, SoundSet addonSoundSet = null)
        {
            Ensure.Argument.NotNull(document);

            if (!(document.Resource is Core.Resources.FileResource))
            {
                throw new Exception("internal error : document.ProjectDocument.Resources must be FileResource.");
            }

            return addonSoundSet == null
                ? Path.ChangeExtension(Path.GetFileName(document.Resource.Key), "depend")
                : Path.ChangeExtension(addonSoundSet.Name, "depend");
        }

        public static string GetIntermediateOutputPath(this SoundProjectDocument document)
        {
            Ensure.Argument.NotNull(document);
            Ensure.Argument.NotNull(document.Project);

            return Path.Combine(
                document.GetDirectoryPath(),
                document.Project.IntermediateOutputPath
                ).GetFullPath();
        }

        public static string GetDirectoryPath(this SoundProjectDocument document)
        {
            Ensure.Argument.NotNull(document);

            if (!(document.Resource is Core.Resources.FileResource))
            {
                throw new Exception("internal error : document.Resources must be FileResource.");
            }

            return Path.GetDirectoryName(document.Resource.Key);
        }
    }
}
