﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Core.Collections;
    using Core.Parameters;
    using Projects;
    using System;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    internal static class ComponentEx
    {
        public static IOutput GetOutputTarget(this Component component)
        {
            Ensure.Argument.NotNull(component);

            if (!component.Parameters.ContainsKey(ConversionParameterNames.OutputTarget))
            {
                component.Parameters.AddValue(
                    ConversionParameterNames.OutputTarget,
                    new ObjectParameterValue<IOutput>());
            }

            return component.Parameters[ConversionParameterNames.OutputTarget].Value as IOutput;
        }

        public static void SetOutputTarget(this Component component, IOutput value)
        {
            Ensure.Argument.NotNull(component);

            if (!component.Parameters.ContainsKey(ConversionParameterNames.OutputTarget))
            {
                component.Parameters.AddValue(
                    ConversionParameterNames.OutputTarget,
                    new ObjectParameterValue<IOutput>());
            }

            component.Parameters[ConversionParameterNames.OutputTarget].Value = value;
        }

        public static bool IsConvertTarget(this Component component)
        {
            return component.IsEnabled && !component.GetIsExcluded();
        }

        public static bool IsHierarchicalConvertTarget(this Component component)
        {
            while (component != null)
            {
                if (!component.IsConvertTarget())
                {
                    return false;
                }

                component = component.Parent;
            }

            return true;
        }

        public static bool GetIsExcluded(this Component component)
        {
            Ensure.Argument.NotNull(component);

            if (!component.Parameters.ContainsKey(ConversionParameterNames.IsExcluded))
            {
                return false;
            }

            return (bool)component.Parameters[ConversionParameterNames.IsExcluded].Value;
        }

        public static void SetIsExcluded(this Component component, bool isExcluded)
        {
            Ensure.Argument.NotNull(component);

            if (!component.Parameters.ContainsKey(ConversionParameterNames.IsExcluded))
            {
                component.Parameters.AddValue(
                    ConversionParameterNames.IsExcluded,
                    new BoolParameterValue(false));
            }

            component.Parameters[ConversionParameterNames.IsExcluded].Value = isExcluded;
        }

        public static string GetFilePathForConvert(this Component component)
        {
            Ensure.Argument.NotNull(component);

            if (component is WaveSoundClipConvertModel)
            {
                Ensure.Operation.ObjectNotNull(((WaveSoundClipConvertModel)component).Model);
                return ((WaveSoundClipConvertModel)component).Model.Path;
            }

            var filePathParameter = component.Parameters.GetValue(ProjectParameterNames.FilePath);

            if (filePathParameter == null)
            {
                return null;
            }

            return (string)filePathParameter.Value;
        }
    }
}
